VERSION 5.00
Begin VB.Form frmTray 
   Caption         =   "Form1"
   ClientHeight    =   3105
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4680
   Icon            =   "frmTray.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   3105
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.Menu mnuTray 
      Caption         =   "Tray"
      Begin VB.Menu mnuShow 
         Caption         =   "Restore"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "Exit"
      End
   End
End
Attribute VB_Name = "frmTray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Tray Callbacks
Private Const NIM_ADD            As Long = &H0
Private Const NIM_MODIFY         As Long = &H1
Private Const NIM_DELETE         As Long = &H2
Private Const NIF_MESSAGE        As Long = &H1
Private Const NIF_ICON           As Long = &H2
Private Const NIF_TIP            As Long = &H4
Private Const NIF_STATE          As Long = &H8
Private Const NIF_INFO           As Long = &H10
Private Const NIS_ISHIDDEN       As Long = &H1
Private Const NIS_SHAREDICON     As Long = &H2

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, y As Single)
On Error GoTo hErr
    If Not inTray Then Exit Sub
    Static Message As Long
    Message = X / Screen.TwipsPerPixelX
    
    Select Case Message
        Case WM_LBUTTONDBLCLK
            mnuShow_Click
        Case WM_RBUTTONDOWN
            If frmBot.WindowState = vbMinimized Or frmBot.Visible = False Then
                mnuShow.Caption = "Restore"
            Else
                mnuShow.Caption = "Hide"
            End If
            PopupMenu mnuTray
    End Select
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Tray", "MouseMove"
End Sub

Public Sub TrayBalloon(Icon As TRAYICONENUM, ByRef Title As String, ByRef Message As String, Optional ByRef Timeout As Long = 3000)
    If Not inTray Then Exit Sub
    With nID
        .uTimeout = Timeout
        .dwInfoFlags = CLng(Icon)
        .szInfoTitle = Title & vbNullChar
        .szInfo = Message & vbNullChar
    End With
    Shell_NotifyIcon NIM_MODIFY, nID
End Sub

Public Sub TrayAdd()
    TrayDelete
    With nID
        .uTimeout = 0
        .dwInfoFlags = 0
        .szInfoTitle = vbNullChar
        .szInfo = vbNullChar
        .szTip = "MirageBot " & App.Major & "." & App.Minor & vbNullChar
        .cbSize = Len(nID)
        .hwnd = frmTray.hwnd
        .uID = vbNull
        .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE Or NIF_INFO
        .uCallbackMessage = WM_MOUSEMOVE
        .dwState = NIS_SHAREDICON
        .hIcon = frmTray.Icon
    End With
    Shell_NotifyIcon NIM_ADD, nID
    inTray = True
End Sub

Public Sub TrayDelete()
    Shell_NotifyIcon NIM_DELETE, nID
    inTray = False
End Sub

Private Sub mnuExit_Click()
    Unload frmBot
End Sub

Private Sub mnuShow_Click()
    If frmBot.Visible = False Or frmBot.WindowState = vbMinimized Then
        frmBot.WindowState = frmBot.LastWindowState
        frmBot.Show
    Else
        frmBot.WindowState = vbMinimized
        frmBot.Hide
    End If
End Sub
